unit Blocked;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Pyroedit, ExtCtrls, Ohmap, Ohmstuff;

type
  TBlockEdForm = class(TForm)
    BlockDisplay: TOverHeadMap;
    IconListBox: TListBox;
    Bevel1: TBevel;
    IconDisplay: TImage;
    BlockName: TEdit;
    Label1: TLabel;
    XSize: TPyroEdit;
    YSize: TPyroEdit;
    Label2: TLabel;
    Label3: TLabel;
    PrevBlockButton: TButton;
    NextBlockButton: TButton;
    NewBlockButton: TButton;
    DeleteBlockButton: TButton;
    procedure doinit(Sender: TObject);
    procedure controlswitch(state:Boolean);
    procedure NewBlockButtonClick(Sender: TObject);
    procedure UpdateDisplay;
    procedure cleanup(Sender: TObject; var Action: TCloseAction);
    procedure changesize(Sender: TObject);
    procedure DoDeDrop(Sender, Source: TObject; X, Y: Integer);
    procedure MapDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
    procedure DragButtonUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure UpdateImage(Sender: TObject);
    procedure DragAssignTile(Sender: TObject; Shift: TShiftState; X,Y: Integer);
    procedure AssignTile(Sender: TObject);
    procedure NextBlockButtonClick(Sender: TObject);
    procedure PrevBlockButtonClick(Sender: TObject);
    procedure updatename(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  BlockEdForm: TBlockEdForm;
  blockindex:Integer;
  lastx,lasty,lastz:Integer;
  draggedtile:Integer;

implementation

uses
    Blah;

{$R *.DFM}


procedure TBlockEdForm.doinit(Sender: TObject);
var
a:Integer;
begin
     BlockDisplay.tilexdim:=TMapIcon(iconlist.items[0]).image.width;
     BlockDisplay.tileydim:=TMapIcon(iconlist.items[0]).image.height;
     BlockDisplay.Map:=TOHMap.Create(10,10,1);
     BlockDisplay.Map.Clear;
     BlockDisplay.Iconset[1]:=iconlist;

     if blocklist.count>0 then begin
        controlswitch(true);
        blockindex:=0;
        UpdateDisplay;
     end;

     iconlistbox.clear;
     for a:=0 to iconlist.count-1 do
         Iconlistbox.items.add(TMapIcon(iconlist.items[a]).name);

end;

procedure TBlockEdForm.controlswitch(state:Boolean);
begin
     Xsize.enabled:=state;
     YSize.enabled:=state;
     PrevBlockButton.enabled:=state;
     NextBlockButton.enabled:=state;
     DeleteBlockButton.enabled:=state;
     IconListBox.Enabled:=state;
     BlockName.Enabled:=state;
end;

procedure TBlockEdForm.NewBlockButtonClick(Sender: TObject);
var
block:TBlockDefinition;
begin
     block:=TBlockDefinition.Create;
     block.xsize:=320 div blockdisplay.tilexdim; block.ysize:=320 div blockdisplay.tileydim;
     block.name:='New Block Definition';
     blockindex:=blocklist.add(block);
     controlswitch(true);
     UpdateDisplay;
end;

procedure TBlockEdForm.UpdateDisplay;
var
x,y:Integer;
block:TBlockDefinition;
begin
     block:=TBlockDefinition(blocklist.items[blockindex]);
     Blockname.text:=block.name;
     Xsize.number:=block.xsize;
     Ysize.number:=block.Ysize;
     BlockDisplay.width:=Blockdisplay.tilexdim*block.xsize;
     Blockdisplay.Height:=Blockdisplay.tileydim*block.ysize;
     for x:=0 to block.xsize-1 do
         for y:=0 to block.ysize-1 do
             Blockdisplay.map.seticonat(x,y,Blockdisplay.zpos,
             TBlockDefinition(blocklist.items[blockindex]).GetIconAt(x,y));
     BlockDisplay.Paint;
end;

procedure TBlockEdForm.cleanup(Sender: TObject; var Action: TCloseAction);
begin
     BlockDisplay.Map.clear;
     BlockDisplay.Iconset[1]:=nil;
end;

procedure TBlockEdForm.changesize(Sender: TObject);
var
Block:TBlockDefinition;
begin
     block:=TBlockDefinition(blocklist.items[blockindex]);
     With blockdisplay do begin
          if ((xsize.number*tilexdim)>0) and ((xsize.number*tilexdim)<321) then begin
             width:=tilexdim*Xsize.number;
             block.xsize:=xsize.number;
          end;
          if ((ysize.number*tileydim)>0) and ((ysize.number*tileydim)<321) then begin
             height:=tileydim*ysize.number;
             block.ysize:=ysize.number;
          end;
          Paint;
     end;
end;

procedure TBlockEdForm.UpdateImage(Sender: TObject);
begin
     IconDisplay.Picture.Bitmap:=TMapIcon(BlockDisplay.Iconset[1].Items[IconListBox.ItemIndex]).Image;
end;

procedure TBlockEdForm.DragAssignTile(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
     with BlockDisplay do begin
          if ready then begin
             x:=XMapcoord(x) ; y:=YMapCoord(y) ;
             if (lastx<>X) or (lasty<>y) or (lastz<>Zpos) then begin

                if (ssRight in Shift) and (dragging=false) then begin
                   draggedtile:=map.iconat(x,y,zpos);
                   BlockDisplay.BeginDrag(false);
                   Exit;
                end;

                If (ssLeft in Shift) then begin
                   Selected.X:=x;
                   Selected.Y:=y;
                   Selected.Shift:=Shift;
                   AssignTile(Sender);
                end;
             end;
          end;
     end;
end;

procedure TBlockEdForm.AssignTile(Sender: TObject);
var
x,y,ii:Integer;
shift:TShiftState;
block:TBlockDefinition;
begin
     with Blockdisplay do begin
          if ready then begin
             block:=TBlockDefinition(blocklist.items[blockindex]);
             X:=Selected.X; Y:=Selected.Y; Shift:=Selected.Shift;
             if ssCtrl in shift then begin
                IconListBox.Itemindex:=Map.IconAt(X,Y,Zpos);
                UpdateImage(Sender);
             end
             else if ssShift in shift then begin
               if TMapIcon(Iconset[1].Items[Map.Iconat(X,Y,Zpos)]).alternate>-1 then begin
                  Map.SetIconAt(X,Y,Zpos,Iconset[1].IconIndex(TMapIcon(Iconset[1].Items[Map.Iconat(X,Y,Zpos)]).alternate));
                  block.seticonat(X,Y,Iconset[1].IconIndex(TMapIcon(Iconset[1].Items[Map.Iconat(X,Y,Zpos)]).alternate));
                  Paint;
               end;
             end
          else begin
              ii:=IconListBox.ItemIndex;
              if ready and (ii>-1) then begin
                 Map.SetIconAt(X,Y,ZPos,ii);
                 Block.SetIconat(X,Y,ii);
                 Redraw(X,Y,ZPos,-1);
                 lastx:=X;
                 lasty:=Y;
                 lastz:=ZPos;
              end;
          end;
        end;
     end;
end;

procedure TBlockEdForm.MapDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
     if (source is TOverHeadMap) or ((source is TListBox) and (TControl(source).tag=42)) then
        Accept:=True
     else
         Accept:=False;
end;

procedure TBlockEdForm.DoDeDrop(Sender, Source: TObject; X, Y: Integer);
var
Block:TBlockDefinition;
begin
     block:=TBlockDefinition(blocklist.items[blockindex]);
     with BlockDisplay do begin
          Map.SetIconAt(XMapcoord(x),YMapCoord(y),Zpos,draggedtile);
          block.seticonat(XMapcoord(x),YMapCoord(y),draggedtile);
          Paint;
     end;
end;

procedure TBlockEdForm.DragButtonUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
     if (Blockdisplay.Dragging) then
        Blockdisplay.EndDrag(true);
end;

procedure TBlockEdForm.NextBlockButtonClick(Sender: TObject);
begin
     if (blockindex<blocklist.count-1) then begin
        blockindex:=blockindex+1;
        UpdateDisplay;
     end;
end;

procedure TBlockEdForm.PrevBlockButtonClick(Sender: TObject);
begin
     if (blockindex>0) then begin
        blockindex:=blockindex-1;
        UpdateDisplay;
     end;
end;

procedure TBlockEdForm.updatename(Sender: TObject);
var
Block:TBlockDefinition;
begin
     block:=TBlockDefinition(blocklist.items[blockindex]);
     block.name:=Blockname.text;
end;

end.
